<?php
session_start();
include('connection.php'); // Include the database connection
if(!isset($_SESSION['admin_login'])){
    header('location: expired_session_page.php');

};

// Pagination setup
$records_per_page = 10;  // Number of records to show per page
$page = isset($_GET['page']) ? $_GET['page'] : 1;
$start_from = ($page - 1) * $records_per_page;

// Get the total number of records (for pagination)
$query_total = "SELECT COUNT(*) AS total FROM audit_logging";
$result_total = mysqli_query($con, $query_total);
$row_total = mysqli_fetch_assoc($result_total);
$total_records = $row_total['total'];
$total_pages = ceil($total_records / $records_per_page);

// Filter setup (default to no filter)
$filter_query = "";
if (isset($_GET['filter'])) {
    $filter = mysqli_real_escape_string($con, $_GET['filter']);
    $filter_query = "WHERE DATE(timestamp) = '$filter'"; // Filter by specific date
} elseif (isset($_GET['month'])) {
    $month = mysqli_real_escape_string($con, $_GET['month']);
    $filter_query = "WHERE MONTH(timestamp) = '$month'"; // Filter by specific month
} elseif (isset($_GET['year'])) {
    $year = mysqli_real_escape_string($con, $_GET['year']);
    $filter_query = "WHERE YEAR(timestamp) = '$year'"; // Filter by specific year
}

// Fetch logs with filters and pagination
$query = "SELECT * FROM audit_logging $filter_query ORDER BY timestamp DESC LIMIT $start_from, $records_per_page";
$result = mysqli_query($con, $query);

// Dashboard counts
$query_total_audits = "SELECT COUNT(*) AS total_audits FROM audit_logging";
$result_total_audits = mysqli_query($con, $query_total_audits);
$row_total_audits = mysqli_fetch_assoc($result_total_audits);
$total_audits = $row_total_audits['total_audits'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Audit Log</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .table-container {
            margin-top: 50px;
        }
        .filter-container {
            margin-top: 20px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <!-- Navbar or any other header if needed -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <div class="container-fluid">
            <a class="navbar-brand" href="#">Admin Panel</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link active" href="admin_dashboard.php">Dashboard</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="logout.php">Logout</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <div class="container table-container">
        <h1 class="text-center mb-4">Audit Logs</h1>

        <!-- Dashboard with total audits -->
        <div class="row">
            <div class="col-md-4">
                <div class="alert alert-info" role="alert">
                    <h5>Total Audits: <?php echo $total_audits; ?></h5>
                </div>
            </div>
        </div>

        <!-- Filters -->
        <div class="filter-container">
            <form method="GET" class="d-flex">
                <input type="text" name="filter" class="form-control" placeholder="Filter by Date (YYYY-MM-DD)" value="<?php echo isset($_GET['filter']) ? $_GET['filter'] : ''; ?>">
                <button type="submit" class="btn btn-primary ms-2">Filter</button>
            </form>
            <form method="GET" class="d-flex mt-2">
                <select name="month" class="form-select">
                    <option value="">Filter by Month</option>
                    <?php for ($i = 1; $i <= 12; $i++) { ?>
                        <option value="<?php echo $i; ?>" <?php echo isset($_GET['month']) && $_GET['month'] == $i ? 'selected' : ''; ?>><?php echo date('F', mktime(0, 0, 0, $i, 10)); ?></option>
                    <?php } ?>
                </select>
                <button type="submit" class="btn btn-primary ms-2">Filter</button>
            </form>
            <form method="GET" class="d-flex mt-2">
                <select name="year" class="form-select">
                    <option value="">Filter by Year</option>
                    <?php for ($i = 2020; $i <= date('Y'); $i++) { ?>
                        <option value="<?php echo $i; ?>" <?php echo isset($_GET['year']) && $_GET['year'] == $i ? 'selected' : ''; ?>><?php echo $i; ?></option>
                    <?php } ?>
                </select>
                <button type="submit" class="btn btn-primary ms-2">Filter</button>
            </form>
        </div>

        <!-- Table to display logs -->
        <div class="table-responsive">
            <table class="table table-bordered table-striped">
                <thead class="table-dark">
                    <tr>
                        <th>ID</th>
                        <th>Role</th>
                        <th>Action </th>
                        <th> Statement</th>
                        <th>Table Name</th>
                        <th>Record ID</th>
                        <th>Old Data</th>
                        <th>New Data</th>
                        <th>Timestamp</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    // Check if there are logs to display
                    if (mysqli_num_rows($result) > 0) {
                        while ($row = mysqli_fetch_assoc($result)) {
                            // Create the action statement based on action type
                            $action_statement = '';
                            switch ($row['action_type']) {
                                case 'INSERT':
                                    $action_statement = " {$row['user_id']} inserted new data: '{$row['new_data']}' ";
                                    break;
                                case 'UPDATE':
                                    $action_statement = " {$row['user_id']} updated record ID {$row['record_id']} from '{$row['old_data']}' to '{$row['new_data']}' on {$row['timestamp']}.";
                                    break;
                                case 'DELETE':
                                    $action_statement = " {$row['user_id']} deleted record ID {$row['record_id']} with data '{$row['old_data']}' on {$row['timestamp']}.";
                                    break;
                                case 'SELECT':
                                    $action_statement = " {$row['user_id']} viewed record ID {$row['record_id']} from table {$row['table_name']} on {$row['timestamp']}.";
                                    break;
                            }

                            echo "<tr>
                                    <td>{$row['id']}</td>
                                    <td>{$row['user_id']}</td>
                                    <td>{$row['action_type']}</td>
                                    <td>{$action_statement}</td>
                                    <td>{$row['table_name']}</td>
                                    <td>{$row['record_id']}</td>
                                    <td><pre>{$row['old_data']}</pre></td>
                                    <td><pre>{$row['new_data']}</pre></td>
                                    <td>{$row['timestamp']}</td>
                                  </tr>";
                        }
                    } else {
                        echo "<tr><td colspan='9' class='text-center'>No logs available</td></tr>";
                    }
                    ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <nav aria-label="Page navigation">
            <ul class="pagination justify-content-center">
                <?php
                for ($i = 1; $i <= $total_pages; $i++) {
                    echo "<li class='page-item " . ($i == $page ? 'active' : '') . "'><a class='page-link' href='view_logs.php?page=$i" . (isset($_GET['filter']) ? "&filter=" . $_GET['filter'] : "") . (isset($_GET['month']) ? "&month=" . $_GET['month'] : "") . (isset($_GET['year']) ? "&year=" . $_GET['year'] : "") . "'>$i</a></li>";
                }
                ?>
            </ul>
        </nav>

    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
